/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Directory;
import cds.aladin.MySplitPane;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.Tok;
import cds.aladin.prop.PropPanel;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCStringParser;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.mocmulti.MocItem;
import cds.mocmulti.MultiMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;

public final class DirectoryFilter
extends JFrame
implements ActionListener {
    private static String[] SINTERSECT;
    private Aladin aladin;
    private JTextArea exprArea;
    private JTextField mocArea;
    private JButton btMocShow;
    private JLabel labelIntersect;
    private JLabel labelCollection;
    private boolean flagFormEdit = false;
    private Moc mocFilter = null;
    private JButton storeButton;
    private JButton deleteButton;
    private JTextField nameField;
    private Color BGCOLOR = new Color(220, 220, 220);
    private Color FGCOLOR = new Color(150, 150, 150);
    private static final int SORT_NO = 0;
    private static final int SORT_FREQ = 1;
    private static final int SORT_ALPHA = 2;
    private static final int SORT_LIST = 3;
    private static final String[] REGIME;
    private static final String INTERSECT = "INTER";
    private JCheckBox cbMocPlane;
    private JCheckBox cbMocInLine;
    private JCheckBox cbStcInLine;
    private JCheckBox cbTimeInLine;
    private JCheckBox bxPixFull;
    private JCheckBox bxPixColor;
    private JCheckBox bxHiPS;
    private JCheckBox bxSIA;
    private JCheckBox bxSIA2;
    private JCheckBox bxSSA;
    private JCheckBox bxTAP;
    private JCheckBox bxCS;
    private JCheckBox bxMOC;
    private JCheckBox bxSMOC;
    private JCheckBox bxTMOC;
    private JCheckBox bxSTMOC;
    private JCheckBox bxProg;
    private JCheckBox bxSuperseded;
    private JTextFieldX tfCatNbRow;
    private JTextFieldX tfCoverage;
    private JTextFieldX tfHiPSorder;
    private JTextFieldX tfDescr;
    private JTextFieldX tfMinDate;
    private JTextFieldX tfMaxDate;
    private JTextFieldX tfBibYear;
    private JTextFieldX tMoc;
    private JTextFieldX tSTC;
    private JTextFieldX tTime;
    private Vector<JCheckBox> catVbx;
    private Vector<JCheckBox> authVbx;
    private Vector<JCheckBox> regVbx;
    private Vector<JCheckBox> catkeyVbx;
    private Vector<JCheckBox> catMisVbx;
    private Vector<JCheckBox> assdataVbx;
    private Vector<JCheckBox> catUcdVbx;
    private JComboBox<String> comboMocPlane;
    private JComboBox<String> comboIntersecting;
    private JButton btReset;
    private JButton btApply;
    private NoneSelectedButtonGroup spaceBG;

    private String S(String k) {
        return Aladin.chaine.getString(k);
    }

    private void loadStrings() {
        SINTERSECT = new String[]{this.S("FPOVERLAPS"), this.S("FPISENCLOSED"), this.S("FPCOVERS")};
    }

    public DirectoryFilter(Aladin aladin) {
        this.aladin = aladin;
        this.loadStrings();
        Aladin.setIcon(this);
        this.setTitle(this.S("FPTITLE"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.add((Component)this.getHeaderPanel(), "North");
        contentPane.add((Component)this.getMainFilterPanel(), "Center");
        contentPane.add((Component)this.getValidPanel(), "South");
        contentPane.setBackground(this.BGCOLOR);
        this.pack();
    }

    private JPanel getHeaderPanel() {
        JButton b;
        JPanel storePanel = new JPanel(new FlowLayout(1, 7, 7));
        storePanel.setBackground(this.BGCOLOR);
        storePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.storeButton = b = new JButton(this.S("FPSTORE"));
        Util.toolTip(this.storeButton, this.S("FPSTORETIP"), true);
        this.deleteButton = b = new JButton(this.S("FPDELETE"));
        Util.toolTip(this.deleteButton, this.S("FPDELETETIP"), true);
        JLabel l = new JLabel(this.S("FPNAME"));
        l.setFont(l.getFont().deriveFont(1));
        storePanel.add(l);
        this.nameField = new JTextField(20);
        this.nameField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DirectoryFilter.this.updateWidget();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        storePanel.add(this.nameField);
        b = this.storeButton;
        storePanel.add(b);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryFilter.this.store();
            }
        });
        b = this.deleteButton;
        storePanel.add(b);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryFilter.this.delete();
            }
        });
        storePanel.add(new JLabel("      "));
        storePanel.add(Util.getHelpButton(this, this.S("FPHELP")));
        return storePanel;
    }

    private JPanel createExpPanel() {
        JPanel areaPanel = new JPanel(new BorderLayout(2, 2));
        areaPanel.setBackground(this.BGCOLOR);
        DirectoryFilter.setTitleBorder(areaPanel, " " + this.S("FPRULELABEL") + " ", this.FGCOLOR);
        this.exprArea = new JTextArea(3, 50);
        this.exprArea.setLineWrap(true);
        this.exprArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DirectoryFilter.this.flagFormEdit = true;
                ((DirectoryFilter)DirectoryFilter.this).aladin.directory.flagError = false;
                DirectoryFilter.this.updateWidget();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DirectoryFilter.this.submit();
                }
            }
        });
        this.exprArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DirectoryFilter.this.activateAreaText(true);
            }
        });
        areaPanel.add((Component)this.exprArea, "Center");
        JPanel mocPanel = new JPanel(new BorderLayout(5, 5));
        mocPanel.setBackground(this.BGCOLOR);
        this.labelIntersect = new JLabel("MOC ");
        Util.toolTip(this.labelIntersect, this.S("FPMOCLABELTIP"), true);
        mocPanel.add((Component)this.labelIntersect, "West");
        this.mocArea = new JTextField(46);
        this.mocArea.setEditable(false);
        this.mocArea.setForeground(new Color(80, 80, 80));
        this.mocArea.setBackground(this.BGCOLOR);
        this.mocArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DirectoryFilter.this.flagFormEdit = true;
                DirectoryFilter.this.updateWidget();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DirectoryFilter.this.submit();
                }
            }
        });
        this.mocArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DirectoryFilter.this.activateAreaText(true);
            }
        });
        mocPanel.add((Component)this.mocArea, "Center");
        JPanel p = new JPanel(new FlowLayout(1, 0, 0));
        p.setBackground(this.BGCOLOR);
        JButton bt = this.btMocShow = new JButton(this.S("FPSHOWIT"));
        Util.toolTip(bt, this.S("FPSHOWITTIP"), true);
        bt.setMargin(new Insets(2, 2, 2, 2));
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectoryFilter.this.mocFilter != null) {
                    ((DirectoryFilter)DirectoryFilter.this).aladin.calque.newPlanMOC(DirectoryFilter.this.mocFilter, "Moc filter", null);
                }
            }
        });
        p.add(bt);
        mocPanel.add((Component)p, "East");
        p = new JPanel(new BorderLayout());
        p.setBackground(this.BGCOLOR);
        p.add((Component)mocPanel, "Center");
        JPanel p1 = new JPanel(new FlowLayout());
        p1.setBackground(this.BGCOLOR);
        this.labelCollection = new JLabel();
        this.labelCollection.setFont(this.labelCollection.getFont().deriveFont(1));
        p1.add(this.labelCollection);
        p.add((Component)p1, "South");
        areaPanel.add((Component)p, "South");
        p = new JPanel(new BorderLayout());
        p.setBackground(this.BGCOLOR);
        p.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        p.add((Component)areaPanel, "Center");
        this.activateAreaText(false);
        return p;
    }

    protected void setLabelResume(int nb, int total, boolean hasQuickFilter) {
        boolean isEmpty = this.isEmpty();
        if (isEmpty && !hasQuickFilter) {
            this.labelCollection.setText("<html>&rarr; " + this.S("FPNOACTIVATED") + " &rarr; " + this.S("FPACTIVATED2") + " " + total + "<html>");
            this.labelCollection.setForeground(new Color(80, 80, 80));
        } else {
            this.labelCollection.setText("<html>&rarr; " + this.S("FPACTIVATED") + " &rarr; " + this.S("FPACTIVATED1") + " <font size=\"+1\">" + nb + "</font><html>");
            this.labelCollection.setForeground(Aladin.COLOR_GREEN.darker());
        }
    }

    protected synchronized void updateWidget() {
        String name = this.nameField.getText().trim();
        boolean enabled = name.length() > 0 && !this.isEmpty();
        this.storeButton.setEnabled(enabled && !name.equals(Directory.ALLCOLL));
        this.deleteButton.setEnabled(enabled && this.aladin.configuration.filterExpr.containsKey(name) && !name.equals(Directory.ALLCOLL) && !name.equals(Directory.MYLIST));
        String expr = this.aladin.configuration.filterExpr.get(name);
        boolean modif = expr == null ? false : expr.equals(this.exprArea.getText().trim());
        this.storeButton.setText(modif ? this.S("FPUPDATE") : this.S("FPSTORE"));
        this.labelIntersect.setForeground(this.mocArea.getText().trim().length() > 0 ? Color.black : this.FGCOLOR);
        ActionListener al = this.comboMocPlane.getActionListeners()[0];
        this.comboMocPlane.removeActionListener(al);
        Object o = this.comboMocPlane.getSelectedItem();
        this.comboMocPlane.removeAllItems();
        Vector<Plan> v = this.aladin.calque.getPlans(PlanMoc.class);
        if (v != null) {
            for (Plan p : v) {
                this.comboMocPlane.addItem(p.label);
            }
            if (o != null) {
                this.comboMocPlane.setSelectedItem(o);
            }
            this.comboMocPlane.setEnabled(true);
            this.cbMocPlane.setEnabled(true);
        } else {
            this.comboMocPlane.addItem(" ------ ");
            this.comboMocPlane.setEnabled(false);
            this.cbMocPlane.setEnabled(false);
        }
        this.comboMocPlane.addActionListener(al);
        if (this.flagFormEdit && !this.exprArea.getText().trim().equals("")) {
            this.activateAreaText(true);
        } else {
            this.activateAreaText(false);
        }
        this.btReset.setEnabled(!this.isEmpty());
        this.btApply.setEnabled(!this.hasBeenApplied());
        this.btMocShow.setEnabled(this.mocArea.getText().length() > 0);
        if (this.isVisible()) {
            Aladin.makeCursor(this, 0);
        }
    }

    private void activateAreaText(boolean flag) {
        if (flag) {
            this.exprArea.setForeground(this.aladin.directory.flagError ? Color.red : Aladin.COLOR_GREEN.darker());
            this.exprArea.setBackground(Color.white);
            this.exprArea.getFont().deriveFont(1);
        } else {
            this.exprArea.setForeground(this.aladin.directory.flagError ? Color.red : new Color(80, 80, 80));
            this.exprArea.setBackground(this.BGCOLOR);
            this.exprArea.getFont().deriveFont(2);
        }
    }

    private void store() {
        String name = this.nameField.getText().trim();
        if (name.equals(Directory.ALLCOLL) || name.equals(Directory.MYLIST)) {
            Aladin.error(this, this.S("FPSTOREWARNING"));
            return;
        }
        String expr = this.exprArea.getText().trim();
        this.aladin.configuration.setDirFilter(name, expr, this.mocFilter);
        this.aladin.configuration.filterExpr.remove(Directory.MYLIST);
        this.aladin.directory.updateDirFilter();
        this.aladin.directory.comboFilter.setSelectedItem(name);
    }

    private void delete() {
        String name = this.nameField.getText().trim();
        if (name.equals(Directory.ALLCOLL)) {
            return;
        }
        if (name.equals(Directory.MYLIST)) {
            return;
        }
        this.aladin.configuration.filterExpr.remove(name);
        this.aladin.directory.updateDirFilter();
        this.reset();
        this.nameField.setText("");
    }

    private JSplitPane getMainFilterPanel() {
        JPanel p = this.createExpPanel();
        MySplitPane pane = new MySplitPane(this.aladin, 0, this.createFilterPanel(), p, 1);
        p.setPreferredSize(new Dimension(0, 120));
        pane.setBackground(this.BGCOLOR);
        return pane;
    }

    private JPanel getValidPanel() {
        JPanel p = new JPanel();
        p.setBackground(this.BGCOLOR);
        p.setLayout(new BorderLayout(10, 10));
        JPanel applyPanel = new JPanel(new FlowLayout(1, 7, 7));
        applyPanel.setBackground(this.BGCOLOR);
        JButton b = this.btApply = new JButton(this.S("FPAPPLY"));
        applyPanel.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryFilter.this.submit();
            }
        });
        b.setFont(b.getFont().deriveFont(1));
        b = this.btReset = new JButton(this.S("FPRESET"));
        applyPanel.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryFilter.this.reset();
            }
        });
        JPanel closePanel = new JPanel(new FlowLayout(1, 7, 7));
        closePanel.setBackground(this.BGCOLOR);
        b = new JButton(this.S("FPCLOSE"));
        closePanel.add(b);
        closePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryFilter.this.setVisible(false);
            }
        });
        p.add((Component)applyPanel, "Center");
        p.add((Component)closePanel, "East");
        return p;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.isEmpty()) {
            this.aladin.directory.comboFilter.setSelectedIndex(0);
            this.aladin.directory.iconFilter.repaint();
        }
        super.setVisible(visible);
    }

    protected static <K, V extends Comparable<V>> Map<K, V> sortByValues(final Map<K, V> map, int ascending) {
        Comparator valueComparator = new Comparator<K>(){
            private int ascending;

            @Override
            public int compare(K k1, K k2) {
                int compare = ((Comparable)map.get(k2)).compareTo((Comparable)map.get(k1));
                if (compare == 0) {
                    return 1;
                }
                return this.ascending * compare;
            }

            public Comparator<K> setParam(int ascending) {
                this.ascending = ascending;
                return this;
            }
        }.setParam(ascending);
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    protected static <K extends Comparable<K>, V> Map<K, V> sortAlpha(Map<K, V> map, int ascending) {
        Comparator valueComparator = new Comparator<K>(){
            private int ascending;

            @Override
            public int compare(K k1, K k2) {
                int compare = k2.compareTo(k1);
                if (compare == 0) {
                    return 1;
                }
                return this.ascending * compare;
            }

            public Comparator<K> setParam(int ascending) {
                this.ascending = ascending;
                return this;
            }
        }.setParam(ascending);
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    protected static <K extends Comparable<K>, V> Map<K, V> sortList(Map<K, V> map, final String[] list) {
        Comparator valueComparator = new Comparator<K>(){

            @Override
            public int compare(K k1, K k2) {
                int j;
                int i = Util.indexInArrayOf((String)k1, list, true);
                if (i == (j = Util.indexInArrayOf((String)k2, list, true))) {
                    return 0;
                }
                if (i == -1) {
                    return 1;
                }
                if (j == -1) {
                    return -1;
                }
                return i - j;
            }

            public Comparator<K> setParam() {
                return this;
            }
        }.setParam();
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    private JPanel createFilterBis(Vector<JCheckBox> vBx, int max, boolean split, String key, String delim, int sort) {
        int n;
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        int total = 0;
        for (MocItem mi : this.aladin.directory) {
            Iterator<String> it = mi.prop.getIteratorValues(key);
            if (it == null) continue;
            while (it.hasNext()) {
                Integer ni;
                int i;
                Object v = it.next();
                if (delim != null && (i = ((String)v).indexOf(delim)) > 0) {
                    v = ((String)v).substring(0, i);
                }
                n = (ni = (Integer)map.get(v)) == null ? 0 : ni;
                map.put(v, new Integer(n + 1));
                ++total;
            }
        }
        Map map1 = sort == 1 ? DirectoryFilter.sortByValues(map, 1) : (sort == 2 ? DirectoryFilter.sortAlpha(map, -1) : (sort == 3 ? DirectoryFilter.sortList(map, REGIME) : map));
        int p = 0;
        int i = 0;
        for (Object k : map1.keySet()) {
            n = (Integer)map.get(k);
            if (max == -2 && n == 1) continue;
            String lab = k;
            lab = lab.replace('_', ' ');
            if (split && lab.length() > 11) {
                lab = lab.substring(0, 8) + "...";
            }
            JCheckBox bx = new JCheckBox(lab, false);
            bx.setToolTipText((String)k + ": " + n + " item" + (n > 1 ? "s" : ""));
            String vm = (String)k + (delim == null ? "" : "*");
            bx.setActionCommand(key + "=" + vm);
            bx.addActionListener(this);
            vBx.add(bx);
            p += n;
            if (max <= 0 || ++i < max) continue;
            break;
        }
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        if (vBx.size() < 12) {
            panel.setLayout(new GridLayout(0, 5));
            panel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
            for (JCheckBox bx : vBx) {
                panel.add(bx);
            }
        } else {
            JPanel p1 = new JPanel(new GridLayout(0, 3));
            for (JCheckBox bx : vBx) {
                p1.add(bx);
            }
            JScrollPane scrollPane = new JScrollPane(p1, 22, 31);
            scrollPane.setPreferredSize(new Dimension(320, 92));
            panel.add((Component)scrollPane, "Center");
            panel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 3));
        }
        return panel;
    }

    private void addParam(HashMap<String, String[]> params, String key, String val) {
        String[] v = params.get(key);
        if (v == null || v.length == 0) {
            params.put(key, new String[]{val});
        } else {
            String[] v1 = new String[v.length + 1];
            System.arraycopy(v, 0, v1, 0, v.length);
            v1[v1.length - 1] = val;
            params.put(key, v1);
        }
    }

    private void addParam(HashMap<String, String[]> inclu, HashMap<String, String[]> exclu, String s) {
        int i = s.indexOf(61);
        if (i == -1) {
            return;
        }
        String val = s.substring(i + 1);
        if (s.charAt(0) == '-') {
            this.addParam(exclu, s.substring(1, i), val);
        } else {
            this.addParam(inclu, s.substring(0, i), val);
        }
    }

    private void submit() {
        if (!this.flagFormEdit) {
            this.generateExpression();
            this.generateMoc();
        }
        this.flagFormEdit = false;
        String expr = this.exprArea.getText();
        if (expr.trim().length() == 0) {
            expr = "*";
        }
        if (this.isVisible()) {
            Aladin.makeCursor(this, 1);
        }
        this.aladin.directory.resumeFilter(expr, this.mocFilter, DirectoryFilter.getIntersect(this.mocFilter));
        this.updateWidget();
        if (this.aladin.directory.comboFilter.getSelectedItem().equals(Directory.MYLISTHTML)) {
            this.aladin.configuration.setDirFilter(Directory.MYLIST, expr, this.mocFilter);
        }
    }

    private void generateMoc() {
        this.mocFilter = this.getMoc();
        this.mocArea.setText(DirectoryFilter.getASCII(this.mocFilter));
    }

    private Moc getMoc() {
        Moc moc = null;
        Moc[] m = new Moc[5];
        int n = 0;
        try {
            if (this.cbMocInLine.isSelected() && this.tMoc.getText().trim().length() > 0) {
                try {
                    m[n++] = Moc.createMoc(this.tMoc.getText().trim());
                }
                catch (Exception e1) {
                    this.cbMocInLine.setSelected(false);
                    throw new Exception("MOC syntax error");
                }
            }
            if (this.cbMocPlane.isSelected()) {
                String label = (String)this.comboMocPlane.getSelectedItem();
                PlanMoc p = (PlanMoc)this.aladin.calque.getPlan(label);
                if (p != null) {
                    m[n++] = p.getMoc();
                } else {
                    this.cbMocPlane.setSelected(false);
                }
            }
            try {
                if (this.cbStcInLine.isSelected() && this.tSTC.getText().trim().length() > 0) {
                    List<STCObj> stcObjects = new STCStringParser().parse(this.tSTC.getText().trim());
                    int n2 = n++;
                    m[n2] = Aladin.createMocRegion(stcObjects, -1, true);
                }
            }
            catch (Exception e1) {
                this.cbStcInLine.setSelected(false);
                throw new Exception("STC syntax error");
            }
            if (this.cbTimeInLine.isSelected() && this.tTime.getText().trim().length() > 0) {
                try {
                    double jdmin = Double.NaN;
                    double jdmax = Double.NaN;
                    String time = this.tTime.getText().trim();
                    int i = time.indexOf(32);
                    if (i < 0) {
                        jdmin = jdmax = Astrodate.dateToJD(time);
                    } else {
                        jdmin = Astrodate.dateToJD(time.substring(0, i));
                        jdmax = Astrodate.dateToJD(time.substring(i + 1));
                    }
                    TMoc tm = new TMoc(41);
                    tm.add(jdmin, jdmax);
                    m[n++] = tm;
                }
                catch (Exception e1) {
                    this.cbTimeInLine.setSelected(false);
                    throw new Exception("Time range syntax error");
                }
            }
            if (n > 0) {
                moc = new STMoc("t0/0 s0/0-11");
                for (int i = 0; i < n; ++i) {
                    moc = moc.intersection(m[i]);
                }
                if (moc.getTimeMoc().isFull()) {
                    moc = moc.getSpaceMoc();
                } else if (moc.getSpaceMoc().isFull()) {
                    moc = moc.getTimeMoc();
                }
            }
        }
        catch (Exception e) {
            Aladin.error(this, "Coverage constraint error" + (e.getMessage() != null ? " (" + e.getMessage() + ")" : ""));
            moc = null;
        }
        if (moc != null) {
            DirectoryFilter.setIntersect(moc, this.comboIntersecting.getSelectedIndex());
        }
        return moc;
    }

    public static void setIntersect(Moc moc, int intersect) {
        if (moc == null) {
            return;
        }
        String value = intersect == 0 ? null : MultiMoc.INTERSECT[intersect];
        try {
            moc.setProperty(INTERSECT, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getIntersect(Moc moc) {
        if (moc == null) {
            return -1;
        }
        String s = moc.getProperty(INTERSECT);
        return s == null ? 0 : Util.indexInArrayOf(s, MultiMoc.INTERSECT, true);
    }

    public static String getASCII(Moc moc) {
        return DirectoryFilter.getASCII(moc, 40);
    }

    public static String getASCII(Moc moc, int nbChars) {
        if (moc == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        if (moc instanceof STMoc) {
            String a = moc.toString();
            if (a.length() > nbChars - 4) {
                a = a.substring(0, nbChars - 4);
            }
            a = a.replace('\n', ' ');
            s.append(a);
        } else {
            if (moc instanceof TMoc) {
                s.append('t');
            }
            long oOrder = -1L;
            for (MocCell x : moc) {
                if ((long)x.order != oOrder) {
                    s.append(" " + x.order + "/");
                } else {
                    s.append(" ");
                }
                s.append(x.start);
                oOrder = x.order;
                if (s.length() <= nbChars - 4) continue;
                s.append(" ...");
                break;
            }
        }
        int intersect = DirectoryFilter.getIntersect(moc);
        if (intersect >= 0) {
            s.append(" (" + SINTERSECT[intersect] + ")");
        }
        return s.toString();
    }

    private void generateExpression() {
        this.exprArea.setText(this.getExpression());
    }

    private String getExpression() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        HashMap<String, String[]> inclu = new HashMap<String, String[]>();
        HashMap<String, String[]> exclu = new HashMap<String, String[]>();
        StringBuilder special = new StringBuilder();
        if (this.bxHiPS.isSelected()) {
            special.append(" && hips_service_url=*");
        }
        if (this.bxSIA.isSelected()) {
            special.append(" && sia*=*");
        }
        if (this.bxSIA2.isSelected()) {
            special.append(" && sia2*=*");
        }
        if (this.bxSSA.isSelected()) {
            special.append(" && ssa*=*");
        }
        if (this.bxTAP.isSelected()) {
            special.append(" && tap*=*");
        }
        if (this.bxCS.isSelected()) {
            special.append(" && cs*=*");
        }
        if (this.bxMOC.isSelected()) {
            special.append(" && moc*=*");
        }
        if (this.bxSMOC.isSelected()) {
            special.append(" && moc_type=smoc");
        }
        if (this.bxTMOC.isSelected()) {
            special.append(" && moc_type=tmoc");
        }
        if (this.bxSTMOC.isSelected()) {
            special.append(" && moc_type=stmoc");
        }
        if (this.bxProg.isSelected()) {
            special.append(" && hips_progenitor_url=*");
        }
        if (this.bxPixFull.isSelected()) {
            special.append(" && (hips_tile_format=*fits* || dataproduct_type=!Image)");
        }
        if (this.bxPixColor.isSelected()) {
            special.append(" && (dataproduct_subtype=color || dataproduct_type=!Image)");
        }
        if (this.bxSuperseded.isSelected()) {
            special.append(" &! obs_superseded_by=*");
        }
        for (JCheckBox jCheckBox : this.catVbx) {
            if (!jCheckBox.isSelected()) continue;
            this.addParam(inclu, exclu, jCheckBox.getActionCommand());
        }
        for (JCheckBox jCheckBox : this.regVbx) {
            if (!jCheckBox.isSelected()) continue;
            this.addParam(inclu, exclu, jCheckBox.getActionCommand());
        }
        for (JCheckBox jCheckBox : this.authVbx) {
            if (!jCheckBox.isSelected()) continue;
            this.addParam(inclu, exclu, jCheckBox.getActionCommand());
        }
        HashMap<String, Object> inclu1 = new HashMap<String, String[]>();
        for (JCheckBox bx : this.catMisVbx) {
            if (!bx.isSelected()) continue;
            this.addParam(inclu1, exclu, bx.getActionCommand());
        }
        if (inclu1.size() > 0) {
            special.append(" && (dataproduct_type!=catalog || " + this.rebuildInclu(inclu1) + ")");
        }
        inclu1 = new HashMap();
        for (JCheckBox bx : this.catkeyVbx) {
            if (!bx.isSelected()) continue;
            this.addParam(inclu1, exclu, bx.getActionCommand());
        }
        if (inclu1.size() > 0) {
            special.append(" && (dataproduct_type!=catalog || " + this.rebuildInclu(inclu1) + ")");
        }
        inclu1 = new HashMap();
        for (JCheckBox bx : this.assdataVbx) {
            if (!bx.isSelected()) continue;
            this.addParam(inclu1, exclu, bx.getActionCommand());
        }
        if (inclu1.size() > 0) {
            special.append(" && (dataproduct_type!=catalog || " + this.rebuildInclu(inclu1) + ")");
        }
        inclu1 = new HashMap();
        for (JCheckBox bx : this.catUcdVbx) {
            if (!bx.isSelected()) continue;
            this.addParam(inclu1, exclu, bx.getActionCommand());
        }
        if (inclu1.size() > 0) {
            special.append(" && (dataproduct_type!=catalog || " + this.rebuildInclu(inclu1) + ")");
        }
        if ((string7 = this.getText(this.tfDescr)).length() != 0) {
            special.append(" && obs_title,obs_description,obs_collection,ID=" + DirectoryFilter.jokerize(string7));
        }
        if ((string6 = this.getText(this.tfCoverage)).length() != 0) {
            special.append(" && moc_sky_fraction=" + this.getFromPourcent(string6));
        }
        if ((string5 = this.getText(this.tfHiPSorder)).length() != 0) {
            special.append(" && (hips_order=" + string5 + "|| hips_service_url=!*)");
        }
        if ((string4 = this.getText(this.tfCatNbRow)).length() != 0) {
            special.append(" && (dataproduct_type!=catalog || nb_rows=" + string4 + ")");
        }
        if ((string3 = this.getMJD(this.tfMinDate)).length() != 0) {
            special.append(" && (t_min>=" + string3 + " || t_min!=*)");
        }
        if ((string2 = this.getMJD(this.tfMaxDate)).length() != 0) {
            special.append(" && (t_max<=" + string2 + " || t_max!=*)");
        }
        if ((string = this.getText(this.tfBibYear)).length() != 0) {
            special.append(" && bib_year=" + string);
        }
        String incluS = this.rebuildInclu(inclu);
        String excluS = this.rebuildExclu(exclu);
        String expr = "";
        if (excluS.length() > 0) {
            expr = incluS.length() > 0 ? "(" + incluS + ") && " + excluS : excluS;
        } else if (incluS.length() > 0) {
            expr = incluS;
        }
        if (special.length() > 0) {
            expr = expr.length() > 0 ? "(" + expr + ")" + special : (special.toString().startsWith(" && ") ? special.substring(4) : "*" + special);
        }
        return expr;
    }

    private String getFromPourcent(String s) {
        int j;
        int i = s.lastIndexOf(37);
        for (j = 0; j < s.length() && !Character.isDigit(s.charAt(j)); ++j) {
        }
        double n = i == -1 ? Double.parseDouble(s.substring(j).trim()) : Double.parseDouble(s.substring(j, i).trim());
        return s.substring(0, j) + (n /= 100.0);
    }

    private String getMJD(JTextField d) {
        String s1 = this.getText(d);
        if (s1.length() == 0) {
            return s1;
        }
        try {
            Long.parseLong(s1);
            return s1;
        }
        catch (Exception exception) {
            String s;
            try {
                double Yd = Double.valueOf(s1);
                s = Astrodate.JDToDate(Astrodate.YdToJD(Yd));
                if (s == null) {
                    return "";
                }
            }
            catch (Exception e) {
                return "";
            }
            return s;
        }
    }

    protected static String jokerize(String s) {
        Tok tok = new Tok(s, ",|");
        StringBuilder s1 = null;
        while (tok.hasMoreTokens()) {
            if (s1 == null) {
                s1 = new StringBuilder("*" + tok.nextToken().trim());
                continue;
            }
            s1.append("*,*" + tok.nextToken().trim());
        }
        s = s1.toString() + "*";
        if (s.indexOf("(") >= 0 || s.indexOf(")") >= 0 || s.indexOf("&&") >= 0 || s.indexOf("||") >= 0 || s.indexOf("&!") >= 0) {
            s = Tok.quote(s);
        }
        return s;
    }

    private String rebuildInclu(HashMap<String, String[]> exclusion) {
        StringBuilder expr = new StringBuilder();
        for (String k : exclusion.keySet()) {
            if (expr.length() > 0) {
                expr.append(" && ");
            }
            expr.append(k + "=");
            boolean first = true;
            for (String v : exclusion.get(k)) {
                if (!first) {
                    expr.append(",");
                }
                first = false;
                expr.append(v);
            }
        }
        return expr.toString().trim();
    }

    private String rebuildExclu(HashMap<String, String[]> exclusion) {
        StringBuilder expr = new StringBuilder();
        for (String k : exclusion.keySet()) {
            if (expr.length() > 0) {
                expr.append(" && ");
            }
            expr.append(k + "!=");
            boolean first = true;
            for (String v : exclusion.get(k)) {
                if (!first) {
                    expr.append(",");
                }
                first = false;
                expr.append(v);
            }
        }
        return expr.toString().trim();
    }

    private String getText(JTextField tf) {
        return tf.getText().trim();
    }

    public void showFilter() {
        Point p = this.aladin.getLocationOnScreen();
        p.x += this.aladin.directory.getWidth() + 30;
        p.y += 20;
        this.setLocation(p);
        this.setVisible(true);
        this.toFront();
    }

    protected boolean isEmpty() {
        return this.exprArea.getText().trim().length() == 0 && this.mocFilter == null;
    }

    protected boolean hasBeenApplied() {
        boolean rep = this.hasBeenApplied1();
        return rep;
    }

    protected boolean hasBeenApplied1() {
        int oInter;
        int inter;
        String oExpr;
        if (this.flagFormEdit) {
            return false;
        }
        Moc moc = this.getMoc();
        if (moc == null && this.mocFilter != null || moc != null && this.mocFilter == null || moc != null && !moc.equals(this.mocFilter)) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        String expr = this.getExpression();
        if (!expr.equals(oExpr = this.exprArea.getText())) {
            return false;
        }
        return this.mocFilter == null || (inter = this.comboIntersecting.getSelectedIndex()) == (oInter = DirectoryFilter.getIntersect(this.mocFilter));
    }

    protected void reset() {
        this.clean();
        this.submit();
    }

    protected void clean() {
        this.nameField.setText("");
        this.bxSuperseded.setSelected(false);
        this.bxPixFull.setSelected(false);
        this.bxHiPS.setSelected(false);
        this.bxSIA.setSelected(false);
        this.bxSIA2.setSelected(false);
        this.bxSSA.setSelected(false);
        this.bxTAP.setSelected(false);
        this.bxCS.setSelected(false);
        this.bxMOC.setSelected(false);
        this.bxSMOC.setSelected(false);
        this.bxTMOC.setSelected(false);
        this.bxSTMOC.setSelected(false);
        this.bxProg.setSelected(false);
        this.bxPixColor.setSelected(false);
        this.tfCatNbRow.setText("");
        this.tfCoverage.setText("");
        this.tfHiPSorder.setText("");
        this.tfDescr.setText("");
        this.tfMinDate.setText("");
        this.tfMaxDate.setText("");
        this.tfBibYear.setText("");
        this.tMoc.setText("");
        this.tSTC.setText("");
        for (JCheckBox bx : this.regVbx) {
            bx.setSelected(false);
        }
        for (JCheckBox bx : this.catVbx) {
            bx.setSelected(false);
        }
        for (JCheckBox bx : this.authVbx) {
            bx.setSelected(false);
        }
        for (JCheckBox bx : this.catMisVbx) {
            bx.setSelected(false);
        }
        for (JCheckBox bx : this.catkeyVbx) {
            bx.setSelected(false);
        }
        for (JCheckBox bx : this.assdataVbx) {
            bx.setSelected(false);
        }
        for (JCheckBox bx : this.catUcdVbx) {
            bx.setSelected(false);
        }
        this.comboIntersecting.setSelectedIndex(0);
        this.spaceBG.clearSelection();
        this.mocFilter = null;
        this.mocArea.setText("");
        this.updateWidget();
    }

    protected void setSpecificalFilter(String name, String expr, Moc moc, int intersect) {
        this.clean();
        if (name.equals(Directory.ALLCOLL)) {
            name = Directory.MYLIST;
        }
        this.nameField.setText(name);
        this.exprArea.setText(expr == null || expr.equals("*") ? "" : expr);
        if (moc != null) {
            this.mocFilter = moc;
            this.mocArea.setText(DirectoryFilter.getASCII(moc));
        }
        this.flagFormEdit = true;
        this.submit();
    }

    public static void setTitleBorder(JPanel p, String title, Color foreground) {
        MatteBorder line = BorderFactory.createMatteBorder(1, 1, 1, 1, foreground);
        if (title == null) {
            p.setBorder(line);
        } else {
            p.setBorder(BorderFactory.createTitledBorder(line, title, 2, 0, Aladin.BOLD, foreground));
        }
    }

    protected JTabbedPane createFilterPanel() {
        JPanel panelCoverage;
        JPanel panelDedicatedToCatalog;
        JPanel panelTechnical;
        JPanel panelGlobalConstraints;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = panelGlobalConstraints = new JPanel(g);
        this.tfDescr = new JTextFieldX(30);
        PropPanel.addCouple(this, p, this.S("FPKEYWORD"), this.S("FPKEYWORDTIP"), this.tfDescr, g, c, 13);
        this.catVbx = new Vector();
        JPanel subPanel = this.createFilterBis(this.catVbx, -2, true, "client_category", "/", 2);
        PropPanel.addCouple(this, p, this.S("FPDATATYPE"), this.S("FPDATATYPETIP"), subPanel, g, c, 13, 2);
        this.regVbx = new Vector();
        subPanel = this.createFilterBis(this.regVbx, -2, true, "obs_regime", null, 3);
        PropPanel.addCouple(this, p, this.S("FPREGIME"), this.S("FPREGIMETIP"), subPanel, g, c, 13, 2);
        this.tfBibYear = new JTextFieldX(10);
        PropPanel.addCouple(this, p, this.S("FPBIB"), this.S("FPBIBTIP"), this.tfBibYear, g, c, 13);
        this.authVbx = new Vector();
        subPanel = this.createFilterBis(this.authVbx, -1, true, "ID", "/", 2);
        PropPanel.addCouple(this, p, this.S("FPAUTH"), this.S("FPAUTHTIP"), subPanel, g, c, 13, 2);
        subPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.tfMinDate = new JTextFieldX(10);
        this.tfMaxDate = new JTextFieldX(10);
        subPanel.add(this.tfMinDate);
        subPanel.add(new JLabel(" .. "));
        subPanel.add(this.tfMaxDate);
        PropPanel.addCouple(this, p, this.S("FPEPOCH"), this.S("FPEPOCHTIP"), subPanel, g, c, 13);
        this.tfCoverage = new JTextFieldX(15);
        PropPanel.addCouple(this, p, this.S("FPCOVERAGE"), this.S("FPCOVERAGETIP"), this.tfCoverage, g, c, 13);
        p = panelTechnical = new JPanel(g);
        PropPanel.addSectionTitle(p, " " + this.S("FPPROTOLAB"), g, c);
        subPanel = new JPanel(new GridLayout(0, 4));
        subPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        NoneSelectedButtonGroup bg = new NoneSelectedButtonGroup();
        JCheckBox bx = this.bxHiPS = new JCheckBox("HiPS");
        subPanel.add(this.bxHiPS);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOHIPS"));
        bx = this.bxSIA = new JCheckBox("SIA(1&2)");
        subPanel.add(this.bxSIA);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOSIA"));
        bx = this.bxSIA2 = new JCheckBox("SIA2");
        subPanel.add(this.bxSIA2);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOSIA"));
        bx = this.bxSSA = new JCheckBox("SSA");
        subPanel.add(this.bxSSA);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOSSA"));
        bx = this.bxTAP = new JCheckBox("TAP");
        subPanel.add(this.bxTAP);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOTAP"));
        bx = this.bxCS = new JCheckBox("Cone Search");
        subPanel.add(this.bxCS);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOCS"));
        bx = this.bxProg = new JCheckBox("HiPS progenitors");
        subPanel.add(this.bxProg);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOHIPSPRO"));
        bx = this.bxMOC = new JCheckBox("MOC");
        subPanel.add(this.bxMOC);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOMOC"));
        bx = this.bxSMOC = new JCheckBox("SMOC");
        subPanel.add(this.bxSMOC);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOSMOC"));
        bx = this.bxTMOC = new JCheckBox("TMOC");
        subPanel.add(this.bxTMOC);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOTMOC"));
        bx = this.bxSTMOC = new JCheckBox("STMOC");
        subPanel.add(this.bxSTMOC);
        bx.setSelected(false);
        bx.addActionListener(this);
        bg.add(bx);
        bx.setToolTipText(this.S("FPPROTOTMOC"));
        PropPanel.addCouple(this, p, this.S("FPPROTO") + " ", this.S("FPPROTOTIP"), subPanel, g, c, 13, 2);
        PropPanel.addFilet(p, g, c, 30, 0);
        PropPanel.addSectionTitle(p, " " + this.S("FPHIPSLAB"), g, c);
        this.tfHiPSorder = new JTextFieldX(15);
        PropPanel.addCouple(this, p, this.S("FPHIPSORDER"), this.S("FPHIPSORDERTIP"), this.tfHiPSorder, g, c, 13);
        bg = new NoneSelectedButtonGroup();
        subPanel = new JPanel(new FlowLayout(0, 0, 0));
        bx = this.bxPixFull = new JCheckBox(this.S("FPHIPSPIXEL1"));
        subPanel.add(this.bxPixFull);
        bx.addActionListener(this);
        bg.add(bx);
        bx = this.bxPixColor = new JCheckBox(this.S("FPHIPSPIXEL2"));
        subPanel.add(this.bxPixColor);
        bx.addActionListener(this);
        bg.add(bx);
        PropPanel.addCouple(this, p, this.S("FPHIPSPIXEL"), this.S("FPHIPSPIXELTIP"), subPanel, g, c, 13);
        p = panelDedicatedToCatalog = new JPanel(g);
        this.catkeyVbx = new Vector();
        subPanel = this.createFilterBis(this.catkeyVbx, -1, false, "obs_astronomy_kw", null, 2);
        PropPanel.addCouple(this, p, this.S("FPCATKEYWORD"), this.S("FPCATKEYWORDTIP"), subPanel, g, c, 13, 2);
        this.catMisVbx = new Vector();
        subPanel = this.createFilterBis(this.catMisVbx, -1, false, "obs_mission", null, 2);
        PropPanel.addCouple(this, p, this.S("FPMISSION"), this.S("FPMISSIONTIP"), subPanel, g, c, 13, 2);
        long max = this.aladin.directory.getNbRowMax();
        this.tfCatNbRow = new JTextFieldX(30);
        PropPanel.addCouple(this, p, this.S("FPNBROWS"), this.S("FPNBROWSTIP") + "\n \n(Note: max nb rows is " + max + ")", this.tfCatNbRow, g, c, 13);
        this.catUcdVbx = new Vector();
        subPanel = new JPanel(new GridLayout(0, 3));
        bx = new JCheckBox("Parallax");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=pos.parallax*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Radial vel.");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=spect.dopplerVeloc*,phys.veloc*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Proper motion");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=pos.pm*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Flux Radio");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.flux*;em.radio*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Flux IR");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.flux*;em.IR*,phot.flux*;em.mm*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Flux Opt");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.flux*;em.opt*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Flux HE");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.flux*;em.X-ray*,phot.flux*;em.gamma*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Mag IR");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.mag*;em.IR.K*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Mag Opt");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.mag*;em.opt.B*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Color");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=phot.color*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        bx = new JCheckBox("Redshift");
        subPanel.add(bx);
        bx.setSelected(false);
        bx.addActionListener(this);
        bx.setActionCommand("data_ucd=src.redshift*");
        this.setToolTip(bx);
        this.catUcdVbx.add(bx);
        JPanel p1 = new JPanel(new BorderLayout(0, 0));
        subPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        p1.add(subPanel);
        p1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        PropPanel.addCouple(this, p, this.S("FPCONTENT"), this.S("FPCONTENTTIP"), p1, g, c, 13, 2);
        this.assdataVbx = new Vector();
        subPanel = this.createFilterBis(this.assdataVbx, -1, false, "associated_dataproduct_type", null, 1);
        PropPanel.addCouple(this, p, this.S("FPASSDATA"), this.S("FPASSDATATIP"), subPanel, g, c, 13, 2);
        subPanel = new JPanel(new FlowLayout(0, 0, 0));
        bx = this.bxSuperseded = new JCheckBox(this.S("FPSUPERSEDEDCB"));
        subPanel.add(this.bxSuperseded);
        bx.addActionListener(this);
        PropPanel.addCouple(this, p, this.S("FPSUPERSEDED"), this.S("FPSUPERSEDEDTIP"), subPanel, g, c, 13);
        p = panelCoverage = new JPanel(g);
        JLabelX desc = new JLabelX("<html>" + this.S("FPSPACEDESC") + "</html>");
        PropPanel.addCouple(this, p, "  ", null, desc, g, c, 13);
        desc.setFont(desc.getFont().deriveFont(2));
        PropPanel.addFilet(p, g, c, 20, 0);
        PropPanel.addSectionTitle(p, " " + this.S("FPSPACEDEFLAB"), g, c);
        p1 = new JPanel(new FlowLayout(0, 0, 0));
        JCheckBox cb = this.cbStcInLine = new JCheckBox(this.S("FPSPACESTCINLINE"));
        cb.addActionListener(this);
        this.tSTC = new JTextFieldX(41, cb);
        p1.add(cb);
        p1.add(this.tSTC);
        PropPanel.addCouple(this, p, "   ", this.S("FPSPACESTCINLINETIP"), p1, g, c, 13);
        p1 = new JPanel(new FlowLayout(0, 0, 0));
        cb = this.cbTimeInLine = new JCheckBox(this.S("FPSPACETIME"));
        cb.addActionListener(this);
        p1.add(cb);
        this.tTime = new JTextFieldX(41, cb);
        p1.add(this.tTime);
        PropPanel.addCouple(this, p, "   ", this.S("FPSPACETIMETIP"), p1, g, c, 13);
        this.spaceBG = new NoneSelectedButtonGroup();
        p1 = new JPanel(new FlowLayout(0, 0, 0));
        cb = this.cbMocPlane = new JCheckBox(this.S("FPSPACEMOC"));
        cb.addActionListener(this);
        cb.setSelected(false);
        this.comboMocPlane = new JComboBox();
        this.comboMocPlane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryFilter.this.cbMocPlane.setSelected(true);
            }
        });
        p1.add(cb);
        p1.add(this.comboMocPlane);
        PropPanel.addCouple(this, p, "  ", this.S("FPSPACEMOCTIP"), p1, g, c, 13);
        p1 = new JPanel(new FlowLayout(0, 0, 0));
        cb = this.cbMocInLine = new JCheckBox(this.S("FPSPACEMOCINLINE"));
        cb.addActionListener(this);
        this.tMoc = new JTextFieldX(41, cb);
        p1.add(cb);
        p1.add(this.tMoc);
        c.insets.bottom += 2;
        PropPanel.addCouple(this, p, "   ", this.S("FPSPACEMOCINLINETIP"), p1, g, c, 13);
        c.insets.bottom -= 2;
        this.comboIntersecting = new JComboBox<String>(SINTERSECT);
        this.comboIntersecting.addActionListener(this);
        PropPanel.addFilet(p, g, c, 20, 2);
        JLabel mode = new JLabel(this.S("FPSPACEINTER"));
        PropPanel.addCouple(this, p, mode, this.S("FPSPACEINTERTIP"), this.comboIntersecting, g, c, 13);
        mode.setFont(mode.getFont().deriveFont(1));
        JTabbedPane globalPanel = new JTabbedPane();
        globalPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        globalPanel.add((Component)panelGlobalConstraints, " " + this.S("FPGLOBAL") + " ");
        globalPanel.add((Component)panelDedicatedToCatalog, " " + this.S("FPCAT") + " ");
        globalPanel.add((Component)panelCoverage, " " + this.S("FPREGION") + " ");
        globalPanel.add((Component)panelTechnical, " " + this.S("FPTECH") + " ");
        return globalPanel;
    }

    private void setToolTip(JCheckBox bx) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.flagFormEdit = false;
        this.submitAction(true);
    }

    protected void submitAction(boolean forceActivation) {
        this.submit();
    }

    static {
        REGIME = new String[]{"Radio", "Millimeter", "Infrared", "Optical", "UV", "EUV", "X-ray", "Gamma-ray"};
    }

    class JTextFieldX
    extends JTextField {
        JTextFieldX(int n) {
            this(n, null);
        }

        JTextFieldX(int n, final JCheckBox cb) {
            super(n);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (cb != null && JTextFieldX.this.getText().trim().length() > 0) {
                            cb.setSelected(true);
                        }
                        DirectoryFilter.this.submitAction(true);
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(200, super.getMinimumSize().height);
        }
    }

    private class NoneSelectedButtonGroup
    extends ButtonGroup {
        private NoneSelectedButtonGroup() {
        }

        @Override
        public void setSelected(ButtonModel model, boolean selected) {
            if (selected) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
        }
    }

    class JLabelX
    extends JLabel {
        JLabelX(String s) {
            super(s);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(400, super.getMinimumSize().height);
        }
    }
}

